use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

public function create()
{
    $categories = Category::all();
    $brands = Brand::all();
    return view('seller.products.create', compact('categories', 'brands'));
}

public function edit(Product $product)
{
    $this->authorize('update', $product);
    $categories = Category::all();
    $brands = Brand::all();
    return view('seller.products.edit', compact('product', 'categories', 'brands'));
}

public function store(Request $request)
{
    $validated = $request->validate([
        'name' => 'required|string|max:255',
        'category_id' => 'required|exists:categories,id',
        'brand_id' => 'nullable|exists:brands,id',
        'description' => 'nullable|string',
        'flavour_profile' => 'nullable|string',
        'nicotine_strength' => 'nullable|string',
        'size' => 'nullable|string',
        'pack_size' => 'nullable|integer',
        'image' => 'nullable|image|max:2048',
    ]);

    $validated['seller_id'] = auth()->id();

    if ($request->hasFile('image')) {
        $validated['image_path'] = $request->file('image')->store('products', 'public');
    }

    Product::create($validated);

    return redirect()->route('seller.products.index')->with('success', 'Product created successfully.');
}

public function update(Request $request, Product $product)
{
    $this->authorize('update', $product);

    $validated = $request->validate([
        'name' => 'required|string|max:255',
        'category_id' => 'required|exists:categories,id',
        'brand_id' => 'nullable|exists:brands,id',
        'description' => 'nullable|string',
        'flavour_profile' => 'nullable|string',
        'nicotine_strength' => 'nullable|string',
        'size' => 'nullable|string',
        'pack_size' => 'nullable|integer',
        'image' => 'nullable|image|max:2048',
    ]);

    if ($request->hasFile('image')) {
        $validated['image_path'] = $request->file('image')->store('products', 'public');
    }

    $product->update($validated);

    return redirect()->route('seller.products.index')->with('success', 'Product updated successfully.');
}